#!/bin/bash

# Verifica se o wayland esta instalado
xdgStr=$XDG_SESSION_TYPE
if [ "$xdgStr" = "wayland" ]; then
  errorMsgConsole="Wayland is not supported by Dinamica EGO, please refer to http://csr.ufmg.br/dinamica/dokuwiki/doku.php?id=dinamica_linux_faq#wayland_not_supported for more information."

  echo "$errorMsgConsole"
  exit 1
fi

# Verifica compatibilidade com a versao da libc.
libcVersion=`ldd --version | head -1 | awk '{print $NF}' | sed -e "s/\.//"`
expectedVersion=226
if [ $(($libcVersion)) -ne $expectedVersion ]; then
  echo "Libc version is not compatible, expected version is $expectedVersion, system version is $libcVersion."
  echo "You can try to download a compatible version from http://csr.ufmg.br/dinamica_utils/download/DinamicaEGO4-Linux-Compatibility-405.zip"
  exit 1
fi

echo "Test OK"
